<?php

	/*==================================================================*\
	######################################################################
	#                                                                    #
	# Copyright 2005 Arca Solutions, Inc. All Rights Reserved.           #
	#                                                                    #
	# This file may not be redistributed in whole or part.               #
	# eDirectory is licensed on a per-domain basis.                      #
	#                                                                    #
	# ---------------- eDirectory IS NOT FREE SOFTWARE ----------------- #
	#                                                                    #
	# http://www.edirectory.com | http://www.edirectory.com/license.html #
	######################################################################
	\*==================================================================*/

	# ----------------------------------------------------------------------------------------------------
	# * FILE: /sitemgr/listingtemplate/delete.php
	# ----------------------------------------------------------------------------------------------------

	# ----------------------------------------------------------------------------------------------------
	# LOAD CONFIG
	# ----------------------------------------------------------------------------------------------------
	include("../../conf/loadconfig.inc.php");

	# ----------------------------------------------------------------------------------------------------
	# VALIDATE FEATURE
	# ----------------------------------------------------------------------------------------------------
	if (LISTINGTEMPLATE_FEATURE != "on" || USING_THEME_TEMPLATE || CUSTOM_LISTINGTEMPLATE_FEATURE != "on") { exit; }

	# ----------------------------------------------------------------------------------------------------
	# SESSION
	# ----------------------------------------------------------------------------------------------------
	sess_validateSMSession();
	permission_hasSMPerm();

	# ----------------------------------------------------------------------------------------------------
	# AUX
	# ----------------------------------------------------------------------------------------------------
	extract($_GET);
	extract($_POST);

	$url_search_params = system_getURLSearchParams((($_POST)?($_POST):($_GET)));

	if ($id) {
		$listingtemplate = new ListingTemplate($id);
        if ($listingtemplate->getString("editable") == "n"){
            header("Location: ".DEFAULT_URL."/".SITEMGR_ALIAS."/listingtemplate/");
            exit;
        }
	} else {
		header("Location: ".DEFAULT_URL."/".SITEMGR_ALIAS."/listingtemplate/");
		exit;
	}

	# ----------------------------------------------------------------------------------------------------
	# SUBMIT
	# ----------------------------------------------------------------------------------------------------
	if ($_SERVER['REQUEST_METHOD'] == "POST") {
		$listingtemplate = new ListingTemplate($_POST['id']);
		$listingtemplate->delete();
		$message = 9;
		header("Location: ".DEFAULT_URL."/".SITEMGR_ALIAS."/listingtemplate/".(($search_page) ? "search.php" : "index.php")."?message=".$message."&screen=$screen&letter=$letter".(($url_search_params) ? "&$url_search_params" : "")."");
		exit;
	}

	# ----------------------------------------------------------------------------------------------------
	# HEADER
	# ----------------------------------------------------------------------------------------------------
	include(SM_EDIRECTORY_ROOT."/layout/header.php");

	# ----------------------------------------------------------------------------------------------------
	# NAVBAR
	# ----------------------------------------------------------------------------------------------------
	include(SM_EDIRECTORY_ROOT."/layout/navbar.php");

?>

<div id="main-right">

	<div id="top-content">
		<div id="header-content">
			<h1><?=string_ucwords(system_showText(LANG_SITEMGR_DELETE))?> <?=string_ucwords(system_showText(LANG_SITEMGR_LISTINGTEMPLATE))?></h1>
		</div>
	</div>

	<div id="content-content">
		<div class="default-margin">

		
			<?
			unset($domainObj);
			$domainObj = new Domain(SELECTED_DOMAIN_ID);

			$registeredDomain = $domainObj->getString("url");
			$registeredDomainID = SELECTED_DOMAIN_ID;

			// Decoded and Nulled By Ayman Qaidi
			// website : www.qaidi.info
			// email : mrqaidi@gmail.com
			$mrqaidi="ok";
		   	if ($mrqaidi =="ok") {
				if ($mrqaidi =="ok") {
					?>

					<div id="warning"> <?=$message_delete?> </div>
					
					<div class="baseForm">

					<form name="listingtemplate" method="POST" action="<?=system_getFormAction($_SERVER["PHP_SELF"])?>">

						<input type="hidden" name="id" value="<?=$id?>" />
						<div class="header-form">
							<?=system_showText(LANG_SITEMGR_DELETE)?> <?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE)?> - <?=$listingtemplate->getString("title")?>
						</div>
						<p class="informationMessage">
							<?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_DELETEQUESTION)?>
						</p>
						
						<?=system_getFormInputSearchParams((($_POST)?($_POST):($_GET)));?>
						<input type="hidden" name="letter" value="<?=$letter?>" />
						<input type="hidden" name="screen" value="<?=$screen?>" />
						<button type="submit" class="input-button-form"><?=system_showText(LANG_SITEMGR_SUBMIT)?></button>
						<button type="button" class="input-button-form" onclick="document.getElementById('formlistingtemplatedeletecancel').submit();"><?=system_showText(LANG_SITEMGR_CANCEL)?></button>

					</form>
					<form id="formlistingtemplatedeletecancel" action="<?=DEFAULT_URL?>/<?=SITEMGR_ALIAS?>/listingtemplate/<?=(($search_page) ? "search.php" : "index.php");?>" method="POST">

						<?=system_getFormInputSearchParams((($_POST)?($_POST):($_GET)));?>
						<input type="hidden" name="letter" value="<?=$letter?>" />
						<input type="hidden" name="screen" value="<?=$screen?>" />

					</form>
					
					</div>

					<?
				} else {
					?><p class="warning"><?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_ACTIVATIONISREQUIRED)?></p><?
				}
			} else {
				?><p class="warning"><?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_ACTIVATIONISREQUIRED)?></p><?
			}
			?>

		</div>
	</div>

	<div id="bottom-content"> </div>

</div>

<?
	# ----------------------------------------------------------------------------------------------------
	# FOOTER
	# ----------------------------------------------------------------------------------------------------
	include(SM_EDIRECTORY_ROOT."/layout/footer.php");

?>
