<?

	/*==================================================================*\
	######################################################################
	#                                                                    #
	# Copyright 2005 Arca Solutions, Inc. All Rights Reserved.           #
	#                                                                    #
	# This file may not be redistributed in whole or part.               #
	# eDirectory is licensed on a per-domain basis.                      #
	#                                                                    #
	# ---------------- eDirectory IS NOT FREE SOFTWARE ----------------- #
	#                                                                    #
	# http://www.edirectory.com | http://www.edirectory.com/license.html #
	######################################################################
	\*==================================================================*/

	# ----------------------------------------------------------------------------------------------------
	# * FILE: /members/help.php
	# ----------------------------------------------------------------------------------------------------

	# ----------------------------------------------------------------------------------------------------
	# LOAD CONFIG
	# ----------------------------------------------------------------------------------------------------
	include("../conf/loadconfig.inc.php");

	# ----------------------------------------------------------------------------------------------------
	# SESSION
	# ----------------------------------------------------------------------------------------------------
	sess_validateSession();
	$acctId = sess_getAccountIdFromSession();
	$url_base = DEFAULT_URL."/".MEMBERS_ALIAS."";

	# ----------------------------------------------------------------------------------------------------
	# AUX
	# ----------------------------------------------------------------------------------------------------
	extract($_GET);
	extract($_POST);

	# ----------------------------------------------------------------------------------------------------
	# HEADER
	# ----------------------------------------------------------------------------------------------------
	include(MEMBERS_EDIRECTORY_ROOT."/layout/header.php");

	# ----------------------------------------------------------------------------------------------------
	# CODE
	# ----------------------------------------------------------------------------------------------------
	$contactObj = new Contact($acctId);
	$name       = $contactObj->getString("first_name")." ".$contactObj->getString("last_name");
	$email      = $contactObj->getString("email");

	if ($_POST) {

		extract($_POST);
		$validate_help = validate_form("help", $_POST, $message_help);

		if ($validate_help) {

			$text = $_POST["text"];
			$text = str_replace("\r\n", "\n", $text);
			$text = str_replace("\n", "\r\n", $text);
            
            setting_get("sitemgr_support_email", $sitemgr_support_email);
			$sitemgr_support_emails = explode(",", $sitemgr_support_email);
            
			$emailSubject = "[".EDIRECTORY_TITLE."] ".system_showText(LANG_NOTIFY_MEMBERSHELP);
            
            $sitemgr_msg = system_showText(LANG_LABEL_SITE_MANAGER).",<br /><br />".system_showText(LANG_NOTIFY_MEMBERSHELP_1)."<br ><br />".system_showText(LANG_NOTIFY_MEMBERSHELP_2).": ".$name."<br /><br />"."".system_showText(LANG_NOTIFY_MEMBERSHELP_3).": ".$email."<br/ ><br />".system_showText(LANG_NOTIFY_MEMBERSHELP_4).": <br /><br />".nl2br($text)."";
            
            system_notifySitemgr($sitemgr_support_emails, $emailSubject, $sitemgr_msg);
		
            $success = true;
            $message_help = system_showText(LANG_CONTACTMSGSUCCESS);

		}

		// removing slashes added if required
		$_POST = format_magicQuotes($_POST);
		$_GET  = format_magicQuotes($_GET);
		extract($_POST);
		extract($_GET);

	}

	# ----------------------------------------------------------------------------------------------------
	# NAVBAR
	# ----------------------------------------------------------------------------------------------------
	include(MEMBERS_EDIRECTORY_ROOT."/layout/navbar.php");

?>

    <div class="content help-page">

        <? require(EDIRECTORY_ROOT."/".SITEMGR_ALIAS."/registration.php"); ?>
        <? require(EDIRECTORY_ROOT."/includes/code/checkregistration.php"); ?>
        <? require(EDIRECTORY_ROOT."/frontend/checkregbin.php"); ?>

        <h2><?=system_showText(LANG_LABEL_HELP)?></h2>

        <?
        $contentObj = new Content();
        $content = $contentObj->retrieveContentByType("Sponsor Help");
        if ($content) {
            echo "<blockquote>";
                echo "<div class=\"dynamicContent\">".$content."</div>";
            echo "</blockquote>";
        }
        ?>

        <form name="help" method="post" action="<?=system_getFormAction($_SERVER["PHP_SELF"])?>">

            <? include(INCLUDES_DIR."/forms/form_help.php"); ?>

            <div class="baseButtons">
                <p class="standardButton">
                    <button type="submit"><?=system_showText(LANG_BUTTON_SEND)?></button>
                </p>
            </div>

        </form>

        <?
        $contentObj = new Content();
        $content = $contentObj->retrieveContentByType("Sponsor Help Bottom");
        if ($content) {
            echo "<blockquote>";
                echo "<div class=\"dynamicContent\">".$content."</div>";
            echo "</blockquote>";
        }
        ?>

    </div>

<?
	# ----------------------------------------------------------------------------------------------------
	# FOOTER
	# ----------------------------------------------------------------------------------------------------
	include(MEMBERS_EDIRECTORY_ROOT."/layout/footer.php");
?>