<?php
	/*==================================================================*\
	######################################################################
	#                                                                    #
	# Copyright 2005 Arca Solutions, Inc. All Rights Reserved.           #
	#                                                                    #
	# This file may not be redistributed in whole or part.               #
	# eDirectory is licensed on a per-domain basis.                      #
	#                                                                    #
	# ---------------- eDirectory IS NOT FREE SOFTWARE ----------------- #
	#                                                                    #
	# http://www.edirectory.com | http://www.edirectory.com/license.html #
	######################################################################
	\*==================================================================*/

	# ----------------------------------------------------------------------------------------------------
	# * FILE: /sitemgr/listingtemplate/index.php
	# ----------------------------------------------------------------------------------------------------

	# ----------------------------------------------------------------------------------------------------
	# LOAD CONFIG
	# ----------------------------------------------------------------------------------------------------
	include("../../conf/loadconfig.inc.php");

	# ----------------------------------------------------------------------------------------------------
	# VALIDATE FEATURE
	# ----------------------------------------------------------------------------------------------------
	if (LISTINGTEMPLATE_FEATURE != "on" || USING_THEME_TEMPLATE || CUSTOM_LISTINGTEMPLATE_FEATURE != "on") {
		header("Location:".DEFAULT_URL."/".SITEMGR_ALIAS."");
		exit;
	}

	# ----------------------------------------------------------------------------------------------------
	# SESSION
	# ----------------------------------------------------------------------------------------------------
	sess_validateSMSession();
	permission_hasSMPerm();

	$url_redirect = "".DEFAULT_URL."/".SITEMGR_ALIAS."/listingtemplate";
	$url_base     = "".DEFAULT_URL."/".SITEMGR_ALIAS."";

	$url_search_params = system_getURLSearchParams((($_POST)?($_POST):($_GET)));

	# ----------------------------------------------------------------------------------------------------
	# CODE
	# ----------------------------------------------------------------------------------------------------
	extract($_POST);
	extract($_GET);

	//increases frequently actions
	if (!isset($message)) system_setFreqActions('listingtemplate_manage','listing');

	// Page Browsing /////////////////////////////////////////
	$pageObj = new pageBrowsing("ListingTemplate", $screen, 10, "title", "title", $letter, "editable = 'y'");
	$listingtemplates = $pageObj->retrievePage();

	$paging_url = DEFAULT_URL."/".SITEMGR_ALIAS."/listingtemplate/index.php";

	// Letters Menu
	$letters = $pageObj->getString("letters");
	foreach($letters as $each_letter)
		if ($each_letter == "#") {
			$letters_menu .= "<a href=\"$paging_url?letter=no\" ".(($letter == "no") ? "style=\"color:#EF413D\"" : "" ).">".string_strtoupper($each_letter)."</a>";
		} else {
			$letters_menu .= "<a href=\"$paging_url?letter=".$each_letter."\" ".(($each_letter == $letter) ? "style=\"color:#EF413D\"" : "" ).">".string_strtoupper($each_letter)."</a>";
		}

	# PAGES DROP DOWN ----------------------------------------------------------------------------------------------
	$pagesDropDown = $pageObj->getPagesDropDown($_GET, $paging_url, $screen, system_showText(LANG_SITEMGR_PAGING_GOTOPAGE)." ", "this.form.submit();");
	# --------------------------------------------------------------------------------------------------------------

	# ----------------------------------------------------------------------------------------------------
	# HEADER
	# ----------------------------------------------------------------------------------------------------
	include(SM_EDIRECTORY_ROOT."/layout/header.php");

	# ----------------------------------------------------------------------------------------------------
	# NAVBAR
	# ----------------------------------------------------------------------------------------------------
	include(SM_EDIRECTORY_ROOT."/layout/navbar.php");

?>

<div id="main-right">
	<div id="top-content">
		<div id="header-content">
			<h1><?=string_ucwords(system_showText(LANG_SITEMGR_LISTINGTEMPLATE_PLURAL))?></h1>
		</div>
	</div>
	<div id="content-content">
		<div class="default-margin">

			<? require(EDIRECTORY_ROOT."/".SITEMGR_ALIAS."/registration.php"); ?>
			<? require(EDIRECTORY_ROOT."/includes/code/checkregistration.php"); ?>
			<? require(EDIRECTORY_ROOT."/frontend/checkregbin.php"); ?>

			<?
			unset($domainObj);
			$domainObj = new Domain(SELECTED_DOMAIN_ID);

			$registeredDomain = $domainObj->getString("url");
			$registeredDomainID = SELECTED_DOMAIN_ID;

			// Decoded and Nulled By Ayman Qaidi
			// website : www.qaidi.info
			// email : mrqaidi@gmail.com
			$mrqaidi="ok";
		   	if ($mrqaidi =="ok") {
				if ($mrqaidi =="ok") {
					?>

					<? include(INCLUDES_DIR."/tables/table_listingtemplate_submenu.php"); ?>

					<br />
					<div class="tip-base">
						<p style="text-align: justify;">
							<a href="<?=DEFAULT_URL;?>/<?=SITEMGR_ALIAS?>/faq/faq.php?keyword=<?=urlencode("listing type");?>" target="_blank"><?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_TIP)?></a>
						</p>
					</div>
					<br />

					<? include(INCLUDES_DIR."/tables/table_paging.php"); ?>

					<? if ($listingtemplates) { ?>
						<? include(INCLUDES_DIR."/tables/table_listingtemplate.php"); ?>
					<? } else { ?>
						<p class="informationMessage">
							<?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_NORECORD)?>
						</p>
					<? } ?>

					<?
				} else {
					?><p class="warning"><?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_ACTIVATIONISREQUIRED)?></p><?
				}
			} else {
				?><p class="warning"><?=system_showText(LANG_SITEMGR_LISTINGTEMPLATE_ACTIVATIONISREQUIRED)?></p><?
			}
			?>

		</div>
	</div>
	<div id="bottom-content">
		 
	</div>
</div>

<?
	# ----------------------------------------------------------------------------------------------------
	# FOOTER
	# ----------------------------------------------------------------------------------------------------
	include(SM_EDIRECTORY_ROOT."/layout/footer.php");
?>
