<?php
	/*==================================================================*\
	######################################################################
	#                                                                    #
	# Copyright 2005 Arca Solutions, Inc. All Rights Reserved.           #
	#                                                                    #
	# This file may not be redistributed in whole or part.               #
	# eDirectory is licensed on a per-domain basis.                      #
	#                                                                    #
	# ---------------- eDirectory IS NOT FREE SOFTWARE ----------------- #
	#                                                                    #
	# http://www.edirectory.com | http://www.edirectory.com/license.html #
	######################################################################
	\*==================================================================*/

	# ----------------------------------------------------------------------------------------------------
	# * FILE: /functions/geo_funct.php
	# ----------------------------------------------------------------------------------------------------

	function geo_GeoIP($debug = false){

        $clientURL = "http://geoip.edirectory.com";
        $updateAPI = '/getInformation.php';
        $agent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)";
		$ref = DEFAULT_URL.$_SERVER["PHP_SELF"];


		if(strpos($_SERVER["REMOTE_ADDR"],"192.168.1") === false){
			$parameters = "o=".md5("getGEOIP")."&info=201.42.135.179"."&v=".VERSION;
		}else{
			$parameters = "o=".md5("getGEOIP")."&info=201.42.135.179"."&v=".VERSION;
		}

		/*
		 * To debug add debug=true on parameters
		 */
		if($debug){
			$req = $parameters."&debug=true";
		}else{
			$req  = $parameters;
		}
		
		$ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $clientURL . $updateAPI);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_NOPROGRESS, true);
        curl_setopt($ch, CURLOPT_VERBOSE, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $req);
        curl_setopt($ch, CURLOPT_USERAGENT, $agent);
        curl_setopt($ch, CURLOPT_REFERER, $ref);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        $response = curl_exec($ch);
        curl_close ($ch);

        if($response){
			
			$auxReturn = "";

			$auxXML = @simplexml_load_string(strrev(base64_decode($response)));

			if($debug){
				echo "<pre>";
				print_r($auxXML);
				echo "</pre>";
				die();
			}else{

				/*
				 * Check if needs settings to locations
				 */
				if($auxXML->location_setting == "on"){
					if(string_strlen(LOCATION1_SYSTEM) && string_strlen($auxXML->country_name)){
						$auxReturn = $auxXML->country_name;
					}
					if(string_strlen(LOCATION3_SYSTEM) && string_strlen($auxXML->region_name)){
						$auxReturn = $auxXML->region_name.(string_strlen($auxReturn) ? ", " : "").$auxReturn;
					}
					if(string_strlen(LOCATION4_SYSTEM) && string_strlen($auxXML->city_name)){
						$auxReturn = $auxXML->city_name.(string_strlen($auxReturn) ? ", " : "").$auxReturn;
					}
				}else{
					if(string_strlen($auxXML->country_name)){
						$auxReturn = $auxXML->country_name;
					}
					if(string_strlen($auxXML->region_name)){
						$auxReturn = $auxXML->region_name.(string_strlen($auxReturn) ? ", " : "").$auxReturn;
					}
					if(string_strlen($auxXML->city_name)){
						$auxReturn = $auxXML->city_name.(string_strlen($auxReturn) ? ", " : "").$auxReturn;
					}
				}

				return $auxReturn;
			}
        }else{
            return false;
        }
    }
?>
